Option Explicit

Const scriptName = "Total Time Played"
Const scriptVer = "1.0.1"

' 1.0.1 - Changed CInt to CLng (sorry, brain fart)

'This VBScript was written for MAME32 users everywhere.
'Copyright (C) 2005 Michael Miller

'Redistribution and use in source and binary forms, with or without
'modification, are permitted provided that the following conditions are met:

'Redistributions of source code must retain the above copyright notice,
'this list of conditions and the following disclaimer.
'Redistributions in binary form must reproduce the above copyright notice,
'this list of conditions and the following disclaimer in the documentation
'and/or other materials provided with the distribution.
'The name of the author may not be used to endorse or promote products
'derived from this software without specific prior written permission.

'THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
'IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
'OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
'IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
'INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
'NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
'DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
'THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
'(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
'THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



Const errNoFile = "To use this script, drop MAME32ui.ini onto this script."

Const qSourceFolder = "Please select your MAME32 folder:"

Const kSourceFileName = "mame32ui.ini"

Const msgPart1 = "You have started "
Const msgPart2a = " game "
Const msgPart2b = " games "
Const msgPart3 = "for a total playing time of "

Const kTimeSep = ":"


' Search for ~Foo "bar"
Const kPlayTimeLine="_play_time (\d+)"
Const kPlayCountLine="_play_count (\d+)"


Const kSubDirChar = "\"
Const kDefaultDestDir = "."

'enum iomode for FileSystemObject
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

'enum format for FileSystemObject
Const OpenAsDefault = -2
Const OpenAsUnicode = -1
Const OpenAsASCII = 0


' Global RegEexes
Dim rePlayCount
Set rePlayCount = New RegExp
rePlayCount.Pattern = kPlayCountLine

Dim rePlayTime
Set rePlayTime = New RegExp
rePlayTime.Pattern = kPlayTimeLine




' Global Objects:
Dim fso
Set fso = CreateObject("Scripting.FileSystemObject")

Main


Function BrowseForFolder(ByRef dialogText)
	Dim returnMe
	returnMe = ""

	Dim options
	options = &H0001 + &H0008 +  &H0050
	
	Dim shellObj
	Set shellObj = WScript.CreateObject("Shell.Application")

	Dim folderObj, oFolderItem
	On Error Resume Next
	Err.Clear
	Set folderObj = shellObj.BrowseForFolder(0, dialogText, options)
	Set oFolderItem = folderObj.Items.Item
	
	returnMe = oFolderItem.Path
	If (Err.Number <> 0) Then
	  returnMe = ""
	End If
	On Error Goto 0

	BrowseForFolder = returnMe
End Function


Private Function GetWorkingDirectory()
  Dim returnMe
  returnMe = WScript.ScriptFullName

  Set returnMe = fso.GetFile(returnMe)
  Set GetWorkingDirectory = returnMe.ParentFolder
End Function

Private Function GetCount(ByRef regEx, ByRef thisLine)
  Dim returnMe
  Dim returnText, matchList

  returnMe = 0

  If regEx.Test(thisLine) Then
    Set matchList = regEx.Execute(thisLine)
    If (matchList.Count = 1) Then
       returnText = matchList(0).Submatches(0)
	   returnMe = CLng(returnText)
    End If
  End If
  
  GetCount = returnMe
End Function

' takes the passed-in text and counts what we want
Private Function ShowCounts(ByRef sourceStream)
    Dim returnMe(2)
    returnMe(0) = 0
	returnMe(1) = 0
    
	Dim thisLine
    Do While Not sourceStream.AtEndOfStream
      thisLine = sourceStream.ReadLine
	  returnMe(0) = returnMe(0) + GetCount(rePlayCount, thisLine)
	  returnMe(1) = returnMe(1) + GetCount(rePlayTime, thisLine)
    Loop
    
    sourceStream.Close

	Dim answer
	answer = msgPart1 & returnMe(0)
	If (returnMe(0) = 1) Then
		answer = answer & msgPart2a
	Else
		answer = answer & msgPart2b
	End If
	answer = answer & msgPart3

	Dim h, m, s, hStr, mStr, sStr
	h = returnMe(1) \ 3600
	m = (returnMe(1) Mod 3600)\60
	s = returnMe(1) Mod 60
	hStr = CStr(h)
	if Len(hStr)=1 then hStr = "0" & hStr
	mStr = CStr(m)
	if Len(mStr)=1 then mStr = "0" & mStr
	sStr = CStr(s)
	if Len(sStr)=1 then sStr = "0" & sStr

	answer = answer & hStr & kTimeSep & mStr & kTimeSep & sStr & "."

	WScript.Echo(answer)

	ShowCounts = returnMe
End Function


Private Function AskForSource(ByRef sourceStream)
	Dim continueOn
	continueOn = False

	' See if it's in our folder
	Dim tempFile, tempPath
	Set tempFile = GetWorkingDirectory()
	tempPath = tempFile.Path
	If Right(tempPath, 1) <> kSubDirChar Then tempPath = tempPath & kSubDirChar
	tempPath = tempPath & kSourceFileName
	If fso.FileExists(tempPath) Then
		Set tempFile = fso.GetFile(tempPath)
		Set sourceStream = tempFile.OpenAsTextStream(ForReading, OpenAsASCII)
		continueOn = True
	Else
		' ask for the text file.  Open it.
		tempPath = BrowseForFolder(qSourceFolder)
		If (tempPath <> "") Then
            If Right(tempPath, 1) <> kSubDirChar Then tempPath = tempPath & kSubDirChar
            tempPath = tempPath & kSourceFileName			
			Set tempFile = fso.GetFile(tempPath)
			Set sourceStream = tempFile.OpenAsTextStream(ForReading, OpenAsASCII)
			continueOn = True
		End If
	End If

	AskForSource = continueOn
End Function


Private Function InterpretCommandLine(ByRef inputFile)
    inputFile = ""

    Dim continueOn
    continueOn = True

    Dim i, args, thisSwitch, thisValue
    Set args = WScript.Arguments
    If (args.Count = 0) Then
	continueOn = False
    ElseIf (args.Count <> 1) Then
        continueOn = False
    Else
	inputFile = args(0)
    End If

    InterpretCommandLine = continueOn
End Function


Public Sub Main

  Dim continueOn, usingStdIn
  Dim inputFile
  continueOn = InterpretCommandLine(inputFile)
  usingStdIn = False

  Dim sourceStream, destStream

  If continueOn Then
    Dim sourceFile
    Set sourceFile = fso.GetFile(inputFile)
    Set sourceStream = sourceFile.OpenAsTextStream(ForReading, OpenAsASCII)
  Else
	' Here you'd check stdIn, if you wanted.
    If Not continueOn Then
	    ' Ask the user for everything:
	    continueOn = AskForSource(sourceStream)
    End If
  End If

  If continueOn Then
    continueOn = ShowCounts(sourceStream)
  Else
    'WScript.Echo(errNoFile)
  End If
  
End Sub
